using System;
using System.Data;
using System.Collections;
using System.Data.SqlClient;
using System.Reflection;
using gov.va.med.vbecs.ExceptionManagement;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// PendingTest
    /// </summary>
    public class PendingTestResultModel
    {
        /// <summary>
        ///  PendingTestId
        /// </summary>
        public int PendingTestId { get; set; }
        /// <summary>
        /// TestType
        /// </summary>
        public TestType TestType { get; private set; }
        /// <summary>
        /// TestTypeName
        /// </summary>
        public string TestTypeName { get; private set; }
        /// <summary>
        /// TestResultId
        /// </summary>
        public string TestResultId { get; set; }
        /// <summary>
        /// TestResultText
        /// </summary>
        public string TestResultText { get; set; }
        /// <summary>
        /// IsInterp
        /// </summary>
        public bool IsInterp
        {
            get
            {
                if (string.IsNullOrWhiteSpace(TestTypeName))
                {
                    return false;
                }
                else
                {
                    return TestTypeName.IndexOf(PendingTestHelper.INTERP_NAME, StringComparison.InvariantCultureIgnoreCase) >= 0;
                }
            }
        }
        /// <summary>
        /// RowVersion
        /// </summary>
        public byte[] RowVersion { get; set; }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="pendingTestId"></param>
        /// <param name="testType"></param>
        /// <param name="testTypeName"></param>
        /// <param name="testResultId"></param>
        /// <param name="testResultText"></param>
        /// <param name="rowVersion"></param>
        public PendingTestResultModel(int pendingTestId, TestType testType, string testTypeName, string testResultId, string testResultText, byte[] rowVersion)
        {
            PendingTestId = pendingTestId;
            TestType = testType;
            TestTypeName = testTypeName;
            TestResultId = testResultId;
            TestResultText = testResultText;
            RowVersion = rowVersion;
        }
        /// <summary>
        /// Clone
        /// </summary>
        /// <returns></returns>
        public PendingTestResultModel Clone()
        {
            return new PendingTestResultModel(PendingTestId, TestType, TestTypeName, TestResultId, TestResultText, RowVersion);
        }
    }
}



